<?php
class VehicleTypeDL extends Config
{
    public function add($params)
    {
        try
        {
            $stmt = $this
                ->conn
                ->prepare("INSERT INTO vehicle_type (vt_name)
				VALUES (
                    :vt_name
				)");
            $stmt->execute($params);
            $last_id = $this
                ->conn
                ->lastInsertId();
            return $last_id;
			
        }
        catch(PDOException $e)
        {
            echo $e->getMessage();
        }
    }
    public function update($params)
    {
        try
        {
            $stmt = $this
                ->conn
                ->prepare("UPDATE vehicle_type 
				SET vt_name=:vt_name
				WHERE vt_id=:vt_id
				");
            $stmt->execute($params);
        }
        catch(PDOException $e)
        {
            echo $e->getMessage();
        }
		
    }
    public function delete($params)
    {
		try
        {
			$stmt = $this
				->conn
				->prepare("DELETE FROM vehicle_type WHERE vt_id=:vt_id");
			$stmt->execute($params);
			return true;
		}
        catch(PDOException $e)
        {
            echo $e->getMessage();
        }

    }
    public function getVehicleTypeById($params)
    {
        $stmt = $this
            ->conn
            ->prepare("SELECT * FROM vehicle_type WHERE vt_id=:vt_id");
        $stmt->execute($params);
        $row = $stmt->fetch();
        return $row;
    }
    public function getVehicleTypeByName($params)
    {
        $stmt = $this
            ->conn
            ->prepare("SELECT * FROM vehicle_type WHERE vt_name=:vt_name");
        $stmt->execute($params);
        $row = $stmt->fetch();
        return $row;
    }

    public function getAllVehicleType()
    {
        $stmt = $this
            ->conn
            ->prepare("SELECT * FROM vehicle_type");
        $stmt->execute();
        $data = $stmt->fetchAll();
        return $data;
    }
	
	public function isVehicleTypeExist($params)
    {
        $stmt = $this
            ->conn
            ->prepare("SELECT * FROM vehicle_type  WHERE lower(trim(vt_name))=lower(trim(:vt_name))");
        $stmt->execute($params);
        $row = $stmt->fetch();
        return $row;
    }
	public function IsVehicleTypeExistEdit($params)
    {
        $stmt = $this
            ->conn
            ->prepare("SELECT * FROM vehicle_type  WHERE lower(trim(vt_name))=lower(trim(:vt_name))  and vt_id!=:vt_id");
        $stmt->execute($params);
        $row = $stmt->fetch();
        return $row;
    }
}
?>